export const ROUTES = {
  HOME: '/',
  CHECKOUT: '/checkout',
  checkoutGuest: '/checkout/guest',
  PROFILE: '/profile',
  CHANGE_PASSWORD: '/change-password',
  ORDERS: '/orders',
  HELP: '/help',
  LOGOUT: '/logout',
  OFFERS: '/offers',
  ORDER_RECEIVED: '/order-received',
  PRODUCT: '/products',
  ORDER: '/order',
  PRIVACY: '/privacy',
  TERMS: '/terms',
  CONTACT: '/contact-us',
  SHOPS: '/shops',
  POLICY: '/privacy',
  FAQ: '/faq',
  FORGET_PASSWORD: '/forget-password',
  SHOP: '/shop',
  LOGIN: '/signin',
  OTP_LOGIN: '/otp-login',
  SIGN_UP: '/signup',
  SEARCH: '/search',
  COLLECTIONS: '/collections',
  CATEGORY: '/category',
  ACCOUNT: '/my-account',
  ACCOUNT_ADDRESS: '/my-account/address',
  ACCOUNT_ORDERS: '/my-account/orders',
  ACCOUNT_CHANGE_PASSWORD: '/my-account/change-password',
  ACCOUNT_CONTACT_NUMBER: '/my-account/contact-number',
  BRAND: '/search?brand',
  TAGS: '/search?tags',
  ACCOUNT_CARDS: '/my-account/cards',
  WISHLISTS: '/my-account/wishlists',
  DOWNLOADS: '/my-account/downloads',
  becomeSeller: '/become-seller',
  verifyEmail: '/verify-email',
  SHOP_URL: (slug: string) => `/shops/${slug}`,
  ORDER_WITH_TRACKING: (tracking_number: string) =>
    `/orders/${encodeURIComponent(tracking_number)}`,
};
